USE [Acuity4Diagnostic]
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[A4S_sp_GetRequestLogs]') AND type in (N'P', N'	PC'))
   DROP PROCEDURE [dbo].[A4S_sp_GetRequestLogs]
GO

CREATE PROCEDURE [dbo].[A4S_sp_GetRequestLogs]
 @search NVARCHAR(255) = '',
 @advancedFilter NVARCHAR(MAX) = '',
 @sort NVARCHAR(255) = '',
 @startIndex INT = 1,
 @endIndex INT = 10
AS
BEGIN
 SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
 DECLARE @stmt nvarchar(max) 
 DECLARE @innerQuery nvarchar(max)
 
 IF (@sort IS NULL OR LEN(@sort) <= 0 ) SET @sort = '[Id] DESC'
 IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0 ) SET @advancedFilter = ' AND ' + @advancedFilter

 SET @innerQuery = '(SELECT [Id], [Url], [StartDate], [EndDate], [Duration], [ApplicationName], [MachineName], [UserId], [ClientId], [SurveyId], [ClientIP], [ClientBrowser] FROM [RequestLog]) AS subquery'
							      
 SET @stmt = '   
  SELECT [Id], [Url], [StartDate], [EndDate], [Duration], [ApplicationName], [MachineName], [UserId], [ClientId], [SurveyId], [ClientIP], [ClientBrowser] FROM
  (SELECT ROW_NUMBER() OVER (ORDER BY ' + @sort + ') AS [RowNum], * 
  FROM ' + @innerQuery + ' WHERE ([ApplicationName] LIKE ''%' + @search + '%'' OR [MachineName] LIKE ''%' + @search + '%'')' + @advancedFilter + ') rowquery
  WHERE [RowNum] >= ' + CONVERT(nvarchar, @startIndex) + ' AND [RowNum] <= ' + CONVERT(nvarchar, @endIndex) + '
  ORDER BY [RowNum]'

 EXEC sp_executesql @stmt
   
 SET @stmt = 'SELECT COUNT(*) AS [TotalRecords] FROM ' + @innerQuery
 EXEC sp_executesql @stmt
 
 IF (@search IS NOT NULL AND LEN(@search) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
 BEGIN
  SET @stmt = 'SELECT COUNT(*) AS [TotalDisplayedRecords] FROM ' + @innerQuery + ' WHERE ([ApplicationName] LIKE ''%' + @search + '%'' OR [MachineName] LIKE ''%' + @search + '%'')' + @advancedFilter
  EXEC sp_executesql @stmt
 END 
END
GO
 
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[A4S_sp_GetMobileOfflineLogs]') AND type in (N'P', N'	PC'))
DROP PROCEDURE [dbo].[A4S_sp_GetMobileOfflineLogs]
GO
CREATE PROCEDURE [dbo].[A4S_sp_GetMobileOfflineLogs]
	@search nvarchar(255) = '',
	@advancedFilter nvarchar(MAX) = '',
	@sort nvarchar(255) = '',
	@startIndex int = 1,
	@endIndex int = 10,
	@clientId int = null
AS
BEGIN
    SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
    DECLARE @sql nvarchar(max) 
    DECLARE @innerQuery nvarchar(max)

    IF (@sort IS NULL OR LEN(@sort) <= 0) SET @sort = '[Id] DESC'
    IF (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0) SET @advancedFilter = ' AND ' + @advancedFilter

    SET @innerQuery = '(
		SELECT [Id], [CreateDate], [ClientId], [UserId], [UserName],
			[Type],  [FileName], [FileDate],
			[DeviceModel], [DeviceUuid]
		FROM [MobileOfflineLogs]'

    if @clientId IS NOT NULL
   	   SET @innerQuery = @innerQuery + ' WHERE ClientId=' + CAST(@clientId as nvarchar(9))
	
    SET @innerQuery = @innerQuery + ') as subquery';

    SET @sql = 'SELECT [Id], [CreateDate], [ClientId], [UserId], [UserName],
		[Type],   [FileName], [FileDate],
		[DeviceModel], [DeviceUuid]
	FROM (
		SELECT ROW_NUMBER() OVER (ORDER BY ' + @sort + ') AS [RowNum], * 
			FROM ' + @innerQuery + ' 
		WHERE [UserName] + '' '' + [FileName]  + '' '' + [DeviceModel]  LIKE ''%' + @search + '%''   ' + @advancedFilter + '
	) rowquery 
	WHERE [RowNum] >= ' + CONVERT(nvarchar, @startIndex) + ' AND [RowNum] <= ' + CONVERT(nvarchar, @endIndex) + '
	ORDER BY [RowNum]';
    EXEC sp_executesql @sql 

    SET @sql = 'SELECT COUNT(*) AS [TotalRecords] FROM ' + @innerQuery
    EXEC sp_executesql @sql

    IF (@search IS NOT NULL AND LEN(@search) > 0) OR (@advancedFilter IS NOT NULL AND LEN(@advancedFilter) > 0)
	BEGIN
		SET @Sql = 'SELECT COUNT(*) AS [TotalDisplayedRecords]
			FROM ' + @innerQuery + '
			WHERE [UserName] + '' '' + [FileName] + '' '' + [DeviceModel] LIKE ''%' + @search + '%'' ' + @advancedFilter
		EXEC sp_executesql @Sql
	END  
END
GO

IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[A4S_sp_GetMobileOfflineLogsWithIds]') AND type in (N'P', N'	PC'))
   DROP PROCEDURE [dbo].[A4S_sp_GetMobileOfflineLogsWithIds]
GO
  
CREATE PROCEDURE [dbo].[A4S_sp_GetMobileOfflineLogsWithIds]
 @ids nvarchar(max) = ''  
AS
BEGIN  
  SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  declare @sql  nvarchar(max)= 'SELECT [Id], [CreateDate], [ClientId], [UserId], [UserName],
   [Type], [File],  [FileName], [FileDate],
   [DeviceModel], [DeviceUuid]
   FROM [MobileOfflineLogs] 
   where [Id] in ('+@ids+')';
  EXEC sp_executesql @Sql

END
GO 
